# DocScheduler

DocScheduler is a FastAPI-based application that manages doctor appointments, prescriptions, and assignments using Redis for real-time availability tracking and Redis for cache storage.

## Features

- Assign prescriptions to available doctors.
- Real-time tracking of doctor availability.
- Automatic reassignment of prescriptions if a doctor is unavailable.
- RESTful API endpoints for managing prescriptions and appointments.

## Requirements

- Python 3.8+
- Redis

## Setup and install dependency
source bin/activate
python3.8 -m pip install -r app/requirements.txt

# To create an executable use the following command

python3.8 -m PyInstaller --onefile app/main.py

# To Stop uvicorn

lsof -i :8010
kill -9 <PID>

# To start a server

python3.8 -m uvicorn app.main:app --workers 1

# To stop a server
pkill -f "python3.8 -m uvicorn"

/api/1rx/v1/scheduler/shutdown
